<?php

namespace Ministra\Lib;

use Exception;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
class Weather implements \Ministra\Lib\StbApi\Weather
{
    protected $provider;
    public function __construct()
    {
        $this->provider = $this->getProvider();
    }
    private function getProvider()
    {
        $class = __NAMESPACE__ . '\\' . \ucfirst(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('weather_provider', 'weatherco'));
        if (!\class_exists($class)) {
            throw new \Exception('Resource "' . $class . '" does not exist');
        }
        return new $class();
    }
    public function getCurrent()
    {
        return $this->provider->getCurrent();
    }
    public function getForecast()
    {
        return $this->provider->getForecast();
    }
    public function updateFullCurrent()
    {
        return $this->provider->updateFullCurrent();
    }
    public function updateFullForecast()
    {
        return $this->provider->updateFullForecast();
    }
    public function getCities($country, $search = '')
    {
        return $this->provider->getCities($country, $search);
    }
    public function getCityFieldName()
    {
        return $this->provider->getCityFieldName();
    }
}
