<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1;
class RESTCommandStbModules extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        if (\count($stb_list) != 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        $uid = $stb_list[0];
        return ['disabled' => \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::p93093fc150632d7105c413128264a517($uid), 'restricted' => \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::m93f08d3cbadaf8869272ffb2e7c5cf07($uid)];
    }
    public function update(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        $uids = $stb_list;
        $data = $request->getPut();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP PUT data is empty');
        }
        if (!\array_key_exists('disabled', $data) && !\array_key_exists('restricted', $data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Update data is empty');
        }
        if (\array_key_exists('disabled', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::fc8459a385e309e58c36ed776c9d4021($uid, $data['disabled']);
            }
        }
        if (\array_key_exists('restricted', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::Z00f1e692bdbbe4b312f95fb416b19395($uid, $data['restricted']);
            }
        }
        return ['disabled' => \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::p93093fc150632d7105c413128264a517($uids[0]), 'restricted' => \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::m93f08d3cbadaf8869272ffb2e7c5cf07($uids[0])];
    }
}
