<?php

namespace Ministra\Lib;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1;
class AccountInfo implements \Ministra\Lib\StbApi\AccountInfo
{
    private $stb;
    public function __construct()
    {
    }
    public function getMainInfo()
    {
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $oss_info = $user->getInfoFromOSS();
        $info = ['fname' => $user->getProfileParam('fname'), 'phone' => $user->getProfileParam('phone'), 'ls' => $user->getProfileParam('ls'), 'mac' => $user->getProfileParam('mac')];
        if (\is_array($oss_info)) {
            $info = \array_merge($info, $oss_info);
        }
        $info['last_change_status'] = $user->getProfileParam('last_change_status');
        if (\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('enable_internal_billing', false) && !\array_key_exists('end_date', $info)) {
            $expire_billing_date = $user->getProfileParam('expire_billing_date');
            if (\strtotime($expire_billing_date) > 0) {
                $info['end_date'] = $expire_billing_date;
            }
        }
        if (!\array_key_exists('account_balance', $info) && $user->getProfileParam('account_balance') != '') {
            $info['account_balance'] = $user->getProfileParam('account_balance');
        }
        if (\array_key_exists('end_date', $info)) {
            $end_time = \strtotime($info['end_date']);
            if ($end_time) {
                $days = \ceil(($end_time - \time()) / (24 * 3600));
                $info['end_date'] = \date(\_('end_date_format'), \strtotime($info['end_date'])) . ' (' . \sprintf(\ngettext('%d day', '%d days', $days), $days) . ')';
            }
        }
        if (\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::get('enable_tariff_plans')) {
            $info['tariff_plan'] = $user->getTariffPlanName();
        }
        return $info;
    }
    public function getPaymentInfo()
    {
        return \sprintf(\_('account_payment_info'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('ls'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('fname'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('login'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('mac'));
    }
    public function getAgreementInfo()
    {
        return \sprintf(\_('account_agreement_info'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('ls'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('fname'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('login'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('mac'));
    }
    public function getTermsInfo()
    {
        return \sprintf(\_('account_terms_info'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('ls'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('fname'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('login'), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->V041d80d62cca44e2567f80cd78f963cd('mac'));
    }
    public function getDemoVideoParts()
    {
        return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('demo_part_video_url', '');
    }
    public function getUserPackages()
    {
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $packages = $user->getPackages();
        $page = (int) $_GET['p'];
        if ($page == 0) {
            $page = 1;
        }
        $sliced_packages = \array_slice($packages, ($page - 1) * 14, 14);
        $sliced_packages = \array_map(function ($package) {
            $package['optional'] = (bool) $package['optional'];
            if ($package['subscribed']) {
                $package['subscribed_str'] = \_('Subscribed');
            } else {
                $package['not_subscribed_str'] = \_('Not subscribed');
            }
            return $package;
        }, $sliced_packages);
        $data = ['total_items' => \count($packages), 'max_page_items' => 14, 'selected_item' => 0, 'cur_page' => 0, 'data' => $sliced_packages];
        return $data;
    }
}
