<?php

namespace Ministra\Admin;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\eca7be640b6f19e3aa662777be52eba5;
use Moust\Silex\Provider\CacheServiceProvider as MCacheServiceProvider;
use Pimple\Container;
class CacheServiceProvider extends \Moust\Silex\Provider\CacheServiceProvider
{
    public function register(\Pimple\Container $app)
    {
        $options = $app->offsetExists('memcache.options') ? $app['memcache.options'] : ['memcache.options' => ['host' => 'localhost', 'default_timeout' => 1800]];
        if (null !== ($instance = $this->checkMemcacheConnect($options['memcache.options']['host']))) {
            $app['caches.options'] = ['memcache' => ['driver' => \get_class($instance) === 'Memcache' ? 'memcache' : 'memcached', 'memcache' => function () use($instance) {
                return $instance;
            }]];
        } else {
            $app['caches.options'] = ['filesystem' => ['driver' => 'file', 'cache_dir' => __DIR__ . '/../resources/cache/admin']];
        }
        return parent::register($app);
    }
    private function checkMemcacheConnect($hosts)
    {
        if (!\class_exists('Memcache') && !\class_exists('Memcached')) {
            return null;
        }
        $memcache = \class_exists('Memcached') ? new \Memcached() : new \Memcache();
        if (!\is_array($hosts)) {
            $hosts = [$hosts];
        }
        $countDisabled = 0;
        foreach ($hosts as $host) {
            if (!$memcache->addServer($host, 11211)) {
                ++$countDisabled;
                \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\eca7be640b6f19e3aa662777be52eba5::h13c78c904a49ae1e429d6bc40007098c('Could not connect to memcached. Host: ' . $host);
            }
            if (!$memcache->set('test', '123')) {
                ++$countDisabled;
                \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\eca7be640b6f19e3aa662777be52eba5::h13c78c904a49ae1e429d6bc40007098c('Could not connect to memcached. Host: ' . $host);
            }
        }
        return $countDisabled === \count($hosts) ? null : $memcache;
    }
}
