<?php

namespace Ministra\Admin;

use Doctrine\DBAL\DriverManager;
use Ministra\Admin\Adapter\DataTableAdapter;
use Ministra\Admin\Container\SilexPsrContainer;
use Ministra\Admin\Lib\Middleware\Pipelines;
use Ministra\Admin\Repository\LicenseKeysRepository;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\c289e887452121479958f4918dfbb7d5;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\C5faf6c06300648979453ecb030edca12\k90d46a1bde84fe79e2698c5eb9af3ff1;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\c57bbd5f5147d7868236d90977abf523 as r7d4615e47c1867cd9956245c76db84ee;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\Z98a82d85fbc3250636e35eed3244f29c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\n103be8efb8d7445a2a867195bbb22596;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\Y07d2752c0bb7f3b5c9e1aeecf7861e47;
use Pimple\Container;
use Pimple\ServiceProviderInterface;
use Psr\Container\ContainerInterface;
use Silex\Application;
class AppServiceProvider implements \Pimple\ServiceProviderInterface
{
    public function register(\Pimple\Container $container)
    {
        $container->offsetSet(\Psr\Container\ContainerInterface::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Container\SilexPsrContainer($app);
        });
        $container->offsetSet('pipelines', function (\Silex\Application $app) {
            return new \Ministra\Admin\Lib\Middleware\Pipelines();
        });
        $this->registerRepository($container);
        $container->offsetSet(\Ministra\Admin\Adapter\DataTableAdapter::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Adapter\DataTableAdapter($app['request_stack']->getCurrentRequest(), $app['db']);
        });
        $this->registerUtilConnection($container);
        $this->registerUtilService($container);
    }
    protected function registerRepository(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Admin\Repository\LicenseKeysRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\LicenseKeysRepository($app['db']);
        });
    }
    protected function registerUtilConnection(\Pimple\Container $container)
    {
        $file = \realpath(__DIR__ . '/../../') . '/deploy/clear_key_util/db_util.sqlite';
        if (!\file_exists($file)) {
            \file_put_contents($file, '');
        }
        if (!\is_writable($file)) {
            throw new \RuntimeException("Clear key util database file does not writable: {$file}");
        }
        $dirs = [\dirname($file) . '/logs', \dirname($file) . '/reports'];
        foreach ($dirs as $dir) {
            if (!\is_writable($file)) {
                throw new \RuntimeException("Directory does not writable: {$dir}");
            }
        }
        if (!\extension_loaded('pdo_sqlite')) {
            throw new \Exception('SQLite extension missing');
        }
        $container->offsetSet('util.connection', \Doctrine\DBAL\DriverManager::getConnection(['driver' => 'pdo_sqlite', 'path' => $file]));
    }
    protected function registerUtilService(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\n103be8efb8d7445a2a867195bbb22596::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\n103be8efb8d7445a2a867195bbb22596($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\Z98a82d85fbc3250636e35eed3244f29c::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\Z98a82d85fbc3250636e35eed3244f29c($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\C5faf6c06300648979453ecb030edca12\k90d46a1bde84fe79e2698c5eb9af3ff1::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\c57bbd5f5147d7868236d90977abf523($app['db']);
        });
        $container->offsetSet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\c289e887452121479958f4918dfbb7d5::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\c289e887452121479958f4918dfbb7d5($app->offsetGet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\Z98a82d85fbc3250636e35eed3244f29c::class), $app->offsetGet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\f43aac94c61399fab94959a50d7a8abb5\n103be8efb8d7445a2a867195bbb22596::class), $app->offsetGet(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\C5faf6c06300648979453ecb030edca12\k90d46a1bde84fe79e2698c5eb9af3ff1::class), \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\cff05f9ec87d13db426b6be495c35612\Y07d2752c0bb7f3b5c9e1aeecf7861e47::c70e77082089913681ad7c5c7b902046, $app->offsetGet('util.path'));
        });
    }
}
