<?php

require __DIR__ . '/autoload.php';
use Doctrine\DBAL\Tools\Console\Helper\ConnectionHelper;
use Ministra\Admin\Command\AnalyzingRoutesCommand;
use Ministra\Admin\Command\ClearCacheCommand;
use Ministra\Admin\Command\DeployMigrationsCommand;
use Ministra\Admin\Command\GenerateRoutesCommand;
use Ministra\Admin\Command\UpdateClearUtilCommand;
use Ministra\Admin\Command\UpgradeMigrationsCommand;
use Ministra\Admin\DoctrineServiceProvider;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\D68b7dd51db7a71c735ffeaa9e6ece8ec\d77ef1b9b8dcfa753ab89d32bc1acf75;
use Silex\Provider\SerializerServiceProvider;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Helper\HelperSet;
use Symfony\Component\Console\Helper\QuestionHelper;
require __DIR__ . '/../app.php';
if (isset($app)) {
    $app->register(new \Silex\Provider\SerializerServiceProvider());
    $cli = new \Symfony\Component\Console\Application();
    $db = $app['db'];
    $app->register(new \Ministra\Admin\DoctrineServiceProvider($cli), ['migrations.directory' => __DIR__ . '/../src/Migrations', 'migrations.name' => 'Ministra DB Migrations', 'migrations.namespace' => 'Ministra\\Migrations', 'migrations.table_name' => 'changelog']);
    $helperSet = new \Symfony\Component\Console\Helper\HelperSet(['connection' => new \Doctrine\DBAL\Tools\Console\Helper\ConnectionHelper($app['db']), 'dialog' => new \Symfony\Component\Console\Helper\QuestionHelper()]);
    require __DIR__ . '/../config/boot_app.php';
    $cli->setHelperSet($helperSet);
    $cli->add((new \Ministra\Admin\Command\GenerateRoutesCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add(new \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\D68b7dd51db7a71c735ffeaa9e6ece8ec\d77ef1b9b8dcfa753ab89d32bc1acf75());
    $cli->add((new \Ministra\Admin\Command\AnalyzingRoutesCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\UpgradeMigrationsCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\DeployMigrationsCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\UpdateClearUtilCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->add((new \Ministra\Admin\Command\ClearCacheCommand())->setContainer($app[\Psr\Container\ContainerInterface::class]));
    $cli->run();
}
